/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.filter;

import io.orqueio.bpm.engine.rest.filter.AbstractEmptyBodyFilter;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class EmptyBodyFilter
extends AbstractEmptyBodyFilter {
    @Override
    public HttpServletRequestWrapper wrapRequest(HttpServletRequest req, final boolean isBodyEmpty, final PushbackInputStream requestBody) {
        return new HttpServletRequestWrapper(req){

            public ServletInputStream getInputStream() throws IOException {
                return new ServletInputStream(){
                    final InputStream inputStream;
                    boolean finished;
                    {
                        this.inputStream = EmptyBodyFilter.this.getRequestBody(isBodyEmpty, requestBody);
                        this.finished = false;
                    }

                    public boolean isFinished() {
                        return this.finished;
                    }

                    public boolean isReady() {
                        return true;
                    }

                    public void setReadListener(ReadListener readListener) {
                        throw new UnsupportedOperationException();
                    }

                    public int read() throws IOException {
                        int data = this.inputStream.read();
                        if (data == -1) {
                            this.finished = true;
                        }
                        return data;
                    }

                    public int available() throws IOException {
                        return this.inputStream.available();
                    }

                    public void close() throws IOException {
                        this.inputStream.close();
                    }

                    public synchronized void mark(int readlimit) {
                        this.inputStream.mark(readlimit);
                    }

                    public synchronized void reset() throws IOException {
                        this.inputStream.reset();
                    }

                    public boolean markSupported() {
                        return this.inputStream.markSupported();
                    }
                };
            }

            public BufferedReader getReader() throws IOException {
                return EmptyBodyFilter.this.getReader(this.getInputStream());
            }
        };
    }
}

