/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.AuthorizationService;
import io.orqueio.bpm.engine.IdentityService;
import io.orqueio.bpm.engine.authorization.Authorization;
import io.orqueio.bpm.engine.authorization.AuthorizationQuery;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.identity.Group;
import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.engine.impl.identity.Authentication;
import io.orqueio.bpm.engine.rest.AuthorizationRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.ResourceOptionsDto;
import io.orqueio.bpm.engine.rest.dto.authorization.AuthorizationCheckResultDto;
import io.orqueio.bpm.engine.rest.dto.authorization.AuthorizationCreateDto;
import io.orqueio.bpm.engine.rest.dto.authorization.AuthorizationDto;
import io.orqueio.bpm.engine.rest.dto.authorization.AuthorizationQueryDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import io.orqueio.bpm.engine.rest.sub.authorization.AuthorizationResource;
import io.orqueio.bpm.engine.rest.sub.authorization.impl.AuthorizationResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import io.orqueio.bpm.engine.rest.util.ResourceUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationRestServiceImpl
extends AbstractAuthorizedRestResource
implements AuthorizationRestService {
    public AuthorizationRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.AUTHORIZATION, "*", objectMapper);
    }

    @Override
    public AuthorizationCheckResultDto isUserAuthorized(String permissionName, String resourceName, Integer resourceType, String resourceId, String userId) {
        String userIdToCheck;
        if (permissionName == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Query parameter 'permissionName' cannot be null");
        }
        if (resourceName == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Query parameter 'resourceName' cannot be null");
        }
        if (resourceType == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Query parameter 'resourceType' cannot be null");
        }
        Authentication currentAuthentication = this.getProcessEngine().getIdentityService().getCurrentAuthentication();
        if (currentAuthentication == null) {
            throw new InvalidRequestException(Response.Status.UNAUTHORIZED, "You must be authenticated in order to use this resource.");
        }
        AuthorizationService authorizationService = this.getProcessEngine().getAuthorizationService();
        ResourceUtil resource = new ResourceUtil(resourceName, resourceType);
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        Permission permission = processEngineConfiguration.getPermissionProvider().getPermissionForName(permissionName, resourceType.intValue());
        String currentUserId = currentAuthentication.getUserId();
        boolean isUserAuthorized = false;
        List<Object> groupIdsToCheck = new ArrayList();
        if (userId != null && !userId.equals(currentUserId)) {
            boolean isCurrentUserAuthorized = authorizationService.isUserAuthorized(currentUserId, currentAuthentication.getGroupIds(), (Permission)Permissions.READ, (Resource)Resources.AUTHORIZATION);
            if (!isCurrentUserAuthorized) {
                throw new InvalidRequestException(Response.Status.FORBIDDEN, "You must have READ permission for Authorization resource.");
            }
            userIdToCheck = userId;
            groupIdsToCheck = this.getUserGroups(userId);
        } else {
            userIdToCheck = currentUserId;
            groupIdsToCheck = currentAuthentication.getGroupIds();
        }
        isUserAuthorized = resourceId == null || "*".equals(resourceId) ? authorizationService.isUserAuthorized(userIdToCheck, groupIdsToCheck, permission, (Resource)resource) : authorizationService.isUserAuthorized(userIdToCheck, groupIdsToCheck, permission, (Resource)resource, resourceId);
        return new AuthorizationCheckResultDto(isUserAuthorized, permissionName, resource, resourceId);
    }

    @Override
    public AuthorizationResource getAuthorization(String id) {
        return new AuthorizationResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<AuthorizationDto> queryAuthorizations(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        AuthorizationQueryDto queryDto = new AuthorizationQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryAuthorizations(queryDto, firstResult, maxResults);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/authorization");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    public List<AuthorizationDto> queryAuthorizations(AuthorizationQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.getObjectMapper());
        AuthorizationQuery query = (AuthorizationQuery)queryDto.toQuery(this.getProcessEngine());
        List<Authorization> resultList = QueryUtil.list(query, firstResult, maxResults);
        return AuthorizationDto.fromAuthorizationList(resultList, this.getProcessEngine().getProcessEngineConfiguration());
    }

    @Override
    public CountResultDto getAuthorizationCount(UriInfo uriInfo) {
        AuthorizationQueryDto queryDto = new AuthorizationQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getAuthorizationCount(queryDto);
    }

    protected CountResultDto getAuthorizationCount(AuthorizationQueryDto queryDto) {
        AuthorizationQuery query = (AuthorizationQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public AuthorizationDto createAuthorization(UriInfo context, AuthorizationCreateDto dto) {
        AuthorizationService authorizationService = this.getProcessEngine().getAuthorizationService();
        Authorization newAuthorization = authorizationService.createNewAuthorization(dto.getType());
        AuthorizationCreateDto.update(dto, newAuthorization, this.getProcessEngine().getProcessEngineConfiguration());
        newAuthorization = authorizationService.saveAuthorization(newAuthorization);
        return this.getAuthorization(newAuthorization.getId()).getAuthorization(context);
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }

    protected List<String> getUserGroups(String userId) {
        List userGroups = this.getIdentityService().createGroupQuery().groupMember(userId).unlimitedList();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : userGroups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }
}

