/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.batch.Batch;
import io.orqueio.bpm.engine.batch.BatchQuery;
import io.orqueio.bpm.engine.batch.BatchStatistics;
import io.orqueio.bpm.engine.batch.BatchStatisticsQuery;
import io.orqueio.bpm.engine.rest.BatchRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.batch.BatchDto;
import io.orqueio.bpm.engine.rest.dto.batch.BatchQueryDto;
import io.orqueio.bpm.engine.rest.dto.batch.BatchStatisticsDto;
import io.orqueio.bpm.engine.rest.dto.batch.BatchStatisticsQueryDto;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.batch.BatchResource;
import io.orqueio.bpm.engine.rest.sub.batch.impl.BatchResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class BatchRestServiceImpl
extends AbstractRestProcessEngineAware
implements BatchRestService {
    public BatchRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public BatchResource getBatch(String batchId) {
        return new BatchResourceImpl(this.getProcessEngine(), batchId);
    }

    @Override
    public List<BatchDto> getBatches(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        BatchQueryDto queryDto = new BatchQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        BatchQuery query = (BatchQuery)queryDto.toQuery(this.getProcessEngine());
        List<Batch> matchingBatches = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<BatchDto> batchResults = new ArrayList<BatchDto>();
        for (Batch matchingBatch : matchingBatches) {
            batchResults.add(BatchDto.fromBatch(matchingBatch));
        }
        return batchResults;
    }

    @Override
    public CountResultDto getBatchesCount(UriInfo uriInfo) {
        ProcessEngine processEngine = this.getProcessEngine();
        BatchQueryDto queryDto = new BatchQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        BatchQuery query = (BatchQuery)queryDto.toQuery(processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public List<BatchStatisticsDto> getStatistics(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        BatchStatisticsQueryDto queryDto = new BatchStatisticsQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        BatchStatisticsQuery query = (BatchStatisticsQuery)queryDto.toQuery(this.getProcessEngine());
        List<BatchStatistics> batchStatisticsList = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<BatchStatisticsDto> statisticsResults = new ArrayList<BatchStatisticsDto>();
        for (BatchStatistics batchStatistics : batchStatisticsList) {
            statisticsResults.add(BatchStatisticsDto.fromBatchStatistics(batchStatistics));
        }
        return statisticsResults;
    }

    @Override
    public CountResultDto getStatisticsCount(UriInfo uriInfo) {
        BatchStatisticsQueryDto queryDto = new BatchStatisticsQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        BatchStatisticsQuery query = (BatchStatisticsQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }
}

