/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.management.JobDefinition;
import io.orqueio.bpm.engine.management.JobDefinitionQuery;
import io.orqueio.bpm.engine.rest.JobDefinitionRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.management.JobDefinitionDto;
import io.orqueio.bpm.engine.rest.dto.management.JobDefinitionQueryDto;
import io.orqueio.bpm.engine.rest.dto.management.JobDefinitionSuspensionStateDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.management.JobDefinitionResource;
import io.orqueio.bpm.engine.rest.sub.management.JobDefinitionResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class JobDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements JobDefinitionRestService {
    public JobDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public JobDefinitionResource getJobDefinition(String jobDefinitionId) {
        return new JobDefinitionResourceImpl(this.getProcessEngine(), jobDefinitionId);
    }

    @Override
    public List<JobDefinitionDto> getJobDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        JobDefinitionQueryDto queryDto = new JobDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryJobDefinitions(queryDto, firstResult, maxResults);
    }

    @Override
    public CountResultDto getJobDefinitionsCount(UriInfo uriInfo) {
        JobDefinitionQueryDto queryDto = new JobDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryJobDefinitionsCount(queryDto);
    }

    @Override
    public List<JobDefinitionDto> queryJobDefinitions(JobDefinitionQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.getObjectMapper());
        JobDefinitionQuery query = (JobDefinitionQuery)queryDto.toQuery(this.getProcessEngine());
        List<JobDefinition> matchingJobDefinitions = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<JobDefinitionDto> jobDefinitionResults = new ArrayList<JobDefinitionDto>();
        for (JobDefinition jobDefinition : matchingJobDefinitions) {
            JobDefinitionDto result = JobDefinitionDto.fromJobDefinition(jobDefinition);
            jobDefinitionResults.add(result);
        }
        return jobDefinitionResults;
    }

    @Override
    public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto queryDto) {
        queryDto.setObjectMapper(this.getObjectMapper());
        JobDefinitionQuery query = (JobDefinitionQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public void updateSuspensionState(JobDefinitionSuspensionStateDto dto) {
        if (dto.getJobDefinitionId() != null) {
            String message = "Either processDefinitionId or processDefinitionKey can be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        try {
            dto.updateSuspensionState(this.getProcessEngine());
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Could not update the suspension state of Job Definitions due to: %s", e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, message);
        }
    }
}

