/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import io.orqueio.bpm.engine.rest.AuthorizationRestService;
import io.orqueio.bpm.engine.rest.BatchRestService;
import io.orqueio.bpm.engine.rest.CaseDefinitionRestService;
import io.orqueio.bpm.engine.rest.CaseExecutionRestService;
import io.orqueio.bpm.engine.rest.CaseInstanceRestService;
import io.orqueio.bpm.engine.rest.ConditionRestService;
import io.orqueio.bpm.engine.rest.DecisionDefinitionRestService;
import io.orqueio.bpm.engine.rest.DecisionRequirementsDefinitionRestService;
import io.orqueio.bpm.engine.rest.DeploymentRestService;
import io.orqueio.bpm.engine.rest.EventSubscriptionRestService;
import io.orqueio.bpm.engine.rest.ExecutionRestService;
import io.orqueio.bpm.engine.rest.ExternalTaskRestService;
import io.orqueio.bpm.engine.rest.FilterRestService;
import io.orqueio.bpm.engine.rest.GroupRestService;
import io.orqueio.bpm.engine.rest.IdentityRestService;
import io.orqueio.bpm.engine.rest.IncidentRestService;
import io.orqueio.bpm.engine.rest.JobDefinitionRestService;
import io.orqueio.bpm.engine.rest.JobRestService;
import io.orqueio.bpm.engine.rest.MessageRestService;
import io.orqueio.bpm.engine.rest.MetricsRestService;
import io.orqueio.bpm.engine.rest.MigrationRestService;
import io.orqueio.bpm.engine.rest.ModificationRestService;
import io.orqueio.bpm.engine.rest.ProcessDefinitionRestService;
import io.orqueio.bpm.engine.rest.ProcessInstanceRestService;
import io.orqueio.bpm.engine.rest.SchemaLogRestService;
import io.orqueio.bpm.engine.rest.SignalRestService;
import io.orqueio.bpm.engine.rest.TaskRestService;
import io.orqueio.bpm.engine.rest.TelemetryRestService;
import io.orqueio.bpm.engine.rest.TenantRestService;
import io.orqueio.bpm.engine.rest.UserRestService;
import io.orqueio.bpm.engine.rest.VariableInstanceRestService;
import io.orqueio.bpm.engine.rest.dto.ProcessEngineDto;
import io.orqueio.bpm.engine.rest.history.HistoryRestService;
import io.orqueio.bpm.engine.rest.impl.AbstractProcessEngineRestServiceImpl;
import io.orqueio.bpm.engine.rest.impl.VersionRestService;
import io.orqueio.bpm.engine.rest.impl.optimize.OptimizeRestService;
import io.orqueio.bpm.engine.rest.spi.ProcessEngineProvider;
import io.orqueio.bpm.engine.rest.util.EngineUtil;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Path(value="/engine")
public class NamedProcessEngineRestServiceImpl
extends AbstractProcessEngineRestServiceImpl {
    public static final String PATH = "/engine";

    @Override
    @Path(value="/{name}/process-definition")
    public ProcessDefinitionRestService getProcessDefinitionService(@PathParam(value="name") String engineName) {
        return super.getProcessDefinitionService(engineName);
    }

    @Override
    @Path(value="/{name}/process-instance")
    public ProcessInstanceRestService getProcessInstanceService(@PathParam(value="name") String engineName) {
        return super.getProcessInstanceService(engineName);
    }

    @Override
    @Path(value="/{name}/execution")
    public ExecutionRestService getExecutionService(@PathParam(value="name") String engineName) {
        return super.getExecutionService(engineName);
    }

    @Override
    @Path(value="/{name}/task")
    public TaskRestService getTaskRestService(@PathParam(value="name") String engineName) {
        return super.getTaskRestService(engineName);
    }

    @Override
    @Path(value="/{name}/identity")
    public IdentityRestService getIdentityRestService(@PathParam(value="name") String engineName) {
        return super.getIdentityRestService(engineName);
    }

    @Override
    @Path(value="/{name}/message")
    public MessageRestService getMessageRestService(@PathParam(value="name") String engineName) {
        return super.getMessageRestService(engineName);
    }

    @Override
    @Path(value="/{name}/variable-instance")
    public VariableInstanceRestService getVariableInstanceService(@PathParam(value="name") String engineName) {
        return super.getVariableInstanceService(engineName);
    }

    @Override
    @Path(value="/{name}/job-definition")
    public JobDefinitionRestService getJobDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getJobDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/job")
    public JobRestService getJobRestService(@PathParam(value="name") String engineName) {
        return super.getJobRestService(engineName);
    }

    @Override
    @Path(value="/{name}/group")
    public GroupRestService getGroupRestService(@PathParam(value="name") String engineName) {
        return super.getGroupRestService(engineName);
    }

    @Override
    @Path(value="/{name}/user")
    public UserRestService getUserRestService(@PathParam(value="name") String engineName) {
        return super.getUserRestService(engineName);
    }

    @Override
    @Path(value="/{name}/authorization")
    public AuthorizationRestService getAuthorizationRestService(@PathParam(value="name") String engineName) {
        return super.getAuthorizationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/incident")
    public IncidentRestService getIncidentService(@PathParam(value="name") String engineName) {
        return super.getIncidentService(engineName);
    }

    @Override
    @Path(value="/{name}/history")
    public HistoryRestService getHistoryRestService(@PathParam(value="name") String engineName) {
        return super.getHistoryRestService(engineName);
    }

    @Override
    @Path(value="/{name}/deployment")
    public DeploymentRestService getDeploymentRestService(@PathParam(value="name") String engineName) {
        return super.getDeploymentRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-definition")
    public CaseDefinitionRestService getCaseDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getCaseDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-instance")
    public CaseInstanceRestService getCaseInstanceRestService(@PathParam(value="name") String engineName) {
        return super.getCaseInstanceRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-execution")
    public CaseExecutionRestService getCaseExecutionRestService(@PathParam(value="name") String engineName) {
        return super.getCaseExecutionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/filter")
    public FilterRestService getFilterRestService(@PathParam(value="name") String engineName) {
        return super.getFilterRestService(engineName);
    }

    @Override
    @Path(value="/{name}/metrics")
    public MetricsRestService getMetricsRestService(@PathParam(value="name") String engineName) {
        return super.getMetricsRestService(engineName);
    }

    @Override
    @Path(value="/{name}/decision-definition")
    public DecisionDefinitionRestService getDecisionDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getDecisionDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/decision-requirements-definition")
    public DecisionRequirementsDefinitionRestService getDecisionRequirementsDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getDecisionRequirementsDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/external-task")
    public ExternalTaskRestService getExternalTaskRestService(@PathParam(value="name") String engineName) {
        return super.getExternalTaskRestService(engineName);
    }

    @Override
    @Path(value="/{name}/migration")
    public MigrationRestService getMigrationRestService(@PathParam(value="name") String engineName) {
        return super.getMigrationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/modification")
    public ModificationRestService getModificationRestService(@PathParam(value="name") String engineName) {
        return super.getModificationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/batch")
    public BatchRestService getBatchRestService(@PathParam(value="name") String engineName) {
        return super.getBatchRestService(engineName);
    }

    @Override
    @Path(value="/{name}/tenant")
    public TenantRestService getTenantRestService(@PathParam(value="name") String engineName) {
        return super.getTenantRestService(engineName);
    }

    @Override
    @Path(value="/{name}/signal")
    public SignalRestService getSignalRestService(@PathParam(value="name") String engineName) {
        return super.getSignalRestService(engineName);
    }

    @Override
    @Path(value="/{name}/condition")
    public ConditionRestService getConditionRestService(@PathParam(value="name") String engineName) {
        return super.getConditionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/optimize")
    public OptimizeRestService getOptimizeRestService(@PathParam(value="name") String engineName) {
        return super.getOptimizeRestService(engineName);
    }

    @Override
    @Path(value="/{name}/version")
    public VersionRestService getVersionRestService(@PathParam(value="name") String engineName) {
        return super.getVersionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/schema/log")
    public SchemaLogRestService getSchemaLogRestService(@PathParam(value="name") String engineName) {
        return super.getSchemaLogRestService(engineName);
    }

    @Override
    @Path(value="/{name}/event-subscription")
    public EventSubscriptionRestService getEventSubscriptionRestService(@PathParam(value="name") String engineName) {
        return super.getEventSubscriptionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/telemetry")
    public TelemetryRestService getTelemetryRestService(@PathParam(value="name") String engineName) {
        return super.getTelemetryRestService(engineName);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessEngineDto> getProcessEngineNames() {
        ProcessEngineProvider provider = EngineUtil.getProcessEngineProvider();
        Set<String> engineNames = provider.getProcessEngineNames();
        ArrayList<ProcessEngineDto> results = new ArrayList<ProcessEngineDto>();
        for (String engineName : engineNames) {
            ProcessEngineDto dto = new ProcessEngineDto();
            dto.setName(engineName);
            results.add(dto);
        }
        return results;
    }

    @Override
    protected URI getRelativeEngineUri(String engineName) {
        return UriBuilder.fromResource(NamedProcessEngineRestServiceImpl.class).path("{name}").build(new Object[]{engineName});
    }
}

