/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.BadUserRequestException;
import io.orqueio.bpm.engine.ManagementService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.RuntimeService;
import io.orqueio.bpm.engine.batch.Batch;
import io.orqueio.bpm.engine.exception.NullValueException;
import io.orqueio.bpm.engine.history.HistoricProcessInstanceQuery;
import io.orqueio.bpm.engine.impl.util.EnsureUtil;
import io.orqueio.bpm.engine.management.SetJobRetriesByProcessAsyncBuilder;
import io.orqueio.bpm.engine.query.Query;
import io.orqueio.bpm.engine.rest.ProcessInstanceRestService;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.VariableValueDto;
import io.orqueio.bpm.engine.rest.dto.batch.BatchDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateAsyncDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import io.orqueio.bpm.engine.rest.dto.runtime.SetJobRetriesByProcessDto;
import io.orqueio.bpm.engine.rest.dto.runtime.batch.CorrelationMessageAsyncDto;
import io.orqueio.bpm.engine.rest.dto.runtime.batch.DeleteProcessInstancesDto;
import io.orqueio.bpm.engine.rest.dto.runtime.batch.SetVariablesAsyncDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.runtime.ProcessInstanceResource;
import io.orqueio.bpm.engine.rest.sub.runtime.impl.ProcessInstanceResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import io.orqueio.bpm.engine.runtime.MessageCorrelationAsyncBuilder;
import io.orqueio.bpm.engine.runtime.ProcessInstance;
import io.orqueio.bpm.engine.runtime.ProcessInstanceQuery;
import io.orqueio.bpm.engine.variable.VariableMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements ProcessInstanceRestService {
    public ProcessInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<ProcessInstanceDto> getProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        List<ProcessInstance> matchingInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<ProcessInstanceDto> instanceResults = new ArrayList<ProcessInstanceDto>();
        for (ProcessInstance instance : matchingInstances) {
            ProcessInstanceDto resultInstance = ProcessInstanceDto.fromProcessInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    @Override
    public CountResultDto getProcessInstancesCount(UriInfo uriInfo) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public ProcessInstanceResource getProcessInstance(String processInstanceId) {
        return new ProcessInstanceResourceImpl(this.getProcessEngine(), processInstanceId, this.getObjectMapper());
    }

    @Override
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto dto) {
        dto.updateSuspensionState(this.getProcessEngine());
    }

    @Override
    public BatchDto updateSuspensionStateAsync(ProcessInstanceSuspensionStateAsyncDto dto) {
        Batch batch = null;
        try {
            batch = dto.updateSuspensionStateAsync(this.getProcessEngine());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto deleteAsync(DeleteProcessInstancesDto dto) {
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        ProcessInstanceQuery processInstanceQuery = null;
        if (dto.getProcessInstanceQuery() != null) {
            processInstanceQuery = (ProcessInstanceQuery)dto.getProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        try {
            Batch batch = runtimeService.deleteProcessInstancesAsync(dto.getProcessInstanceIds(), processInstanceQuery, null, dto.getDeleteReason(), dto.isSkipCustomListeners(), dto.isSkipSubprocesses(), dto.isSkipIoMappings());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = null;
        if (deleteProcessInstancesDto.getHistoricProcessInstanceQuery() != null) {
            historicProcessInstanceQuery = (HistoricProcessInstanceQuery)deleteProcessInstancesDto.getHistoricProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        try {
            Batch batch = runtimeService.deleteProcessInstancesAsync(deleteProcessInstancesDto.getProcessInstanceIds(), null, historicProcessInstanceQuery, deleteProcessInstancesDto.getDeleteReason(), deleteProcessInstancesDto.isSkipCustomListeners(), deleteProcessInstancesDto.isSkipSubprocesses(), deleteProcessInstancesDto.isSkipIoMappings());
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesDto) {
        try {
            EnsureUtil.ensureNotNull((String)"setJobRetriesDto", (Object)setJobRetriesDto);
            EnsureUtil.ensureNotNull((String)"retries", (Object)setJobRetriesDto.getRetries());
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        ProcessInstanceQuery processInstanceQuery = null;
        if (setJobRetriesDto.getProcessInstanceQuery() != null) {
            processInstanceQuery = (ProcessInstanceQuery)setJobRetriesDto.getProcessInstanceQuery().toQuery(this.getProcessEngine());
        }
        try {
            SetJobRetriesByProcessAsyncBuilder builder = this.getProcessEngine().getManagementService().setJobRetriesByProcessAsync(setJobRetriesDto.getRetries().intValue()).processInstanceIds(setJobRetriesDto.getProcessInstances()).processInstanceQuery(processInstanceQuery);
            if (setJobRetriesDto.isDueDateSet()) {
                builder.dueDate(setJobRetriesDto.getDueDate());
            }
            Batch batch = builder.executeAsync();
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesDto) {
        HistoricProcessInstanceQueryDto queryDto = setJobRetriesDto.getHistoricProcessInstanceQuery();
        HistoricProcessInstanceQuery query = null;
        if (queryDto != null) {
            query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.getProcessEngine());
        }
        try {
            ManagementService managementService = this.getProcessEngine().getManagementService();
            SetJobRetriesByProcessAsyncBuilder builder = managementService.setJobRetriesByProcessAsync(setJobRetriesDto.getRetries().intValue()).processInstanceIds(setJobRetriesDto.getProcessInstances()).historicProcessInstanceQuery(query);
            if (setJobRetriesDto.isDueDateSet()) {
                builder.dueDate(setJobRetriesDto.getDueDate());
            }
            Batch batch = builder.executeAsync();
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto setVariablesAsync(SetVariablesAsyncDto setVariablesAsyncDto) {
        Map<String, VariableValueDto> variables = setVariablesAsyncDto.getVariables();
        VariableMap variableMap = null;
        try {
            variableMap = VariableValueDto.toMap(variables, this.getProcessEngine(), this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot set variables: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        List<String> ids = setVariablesAsyncDto.getProcessInstanceIds();
        ProcessInstanceQuery runtimeQuery = (ProcessInstanceQuery)this.toQuery(setVariablesAsyncDto.getProcessInstanceQuery());
        HistoricProcessInstanceQuery historyQuery = (HistoricProcessInstanceQuery)this.toQuery(setVariablesAsyncDto.getHistoricProcessInstanceQuery());
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        Batch batch = null;
        try {
            batch = runtimeService.setVariablesAsync(ids, runtimeQuery, historyQuery, (Map)variableMap);
        }
        catch (AuthorizationException | BadUserRequestException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    @Override
    public BatchDto correlateMessageAsync(CorrelationMessageAsyncDto correlationMessageAsyncDto) {
        Map<String, VariableValueDto> variables = correlationMessageAsyncDto.getVariables();
        VariableMap variableMap = null;
        try {
            variableMap = VariableValueDto.toMap(variables, this.getProcessEngine(), this.objectMapper);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot set variables: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        String messageName = correlationMessageAsyncDto.getMessageName();
        List<String> ids = correlationMessageAsyncDto.getProcessInstanceIds();
        ProcessInstanceQuery runtimeQuery = (ProcessInstanceQuery)this.toQuery(correlationMessageAsyncDto.getProcessInstanceQuery());
        HistoricProcessInstanceQuery historyQuery = (HistoricProcessInstanceQuery)this.toQuery(correlationMessageAsyncDto.getHistoricProcessInstanceQuery());
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        Batch batch = null;
        try {
            MessageCorrelationAsyncBuilder messageCorrelationBuilder = runtimeService.createMessageCorrelationAsync(messageName).setVariables((Map)variableMap);
            if (ids != null) {
                messageCorrelationBuilder.processInstanceIds(ids);
            }
            if (runtimeQuery != null) {
                messageCorrelationBuilder.processInstanceQuery(runtimeQuery);
            }
            if (historyQuery != null) {
                messageCorrelationBuilder.historicProcessInstanceQuery(historyQuery);
            }
            batch = messageCorrelationBuilder.correlateAllAsync();
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return BatchDto.fromBatch(batch);
    }

    protected <T extends Query<?, ?>, R extends AbstractQueryDto<T>> T toQuery(R query) {
        if (query == null) {
            return null;
        }
        return query.toQuery(this.getProcessEngine());
    }
}

