/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricActivityStatisticsQuery;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.DateConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Date;
import java.util.Map;

public class HistoricActivityStatisticsQueryDto
extends AbstractQueryDto<HistoricActivityStatisticsQuery> {
    protected static final String SORT_ORDER_ACTIVITY_ID = "activityId";
    protected String processDefinitionId;
    protected Boolean includeCanceled;
    protected Boolean includeFinished;
    protected Boolean includeCompleteScope;
    protected Boolean includeIncidents;
    protected Date startedAfter;
    protected Date startedBefore;
    protected Date finishedAfter;
    protected Date finishedBefore;
    protected String[] processInstanceIdIn;

    public HistoricActivityStatisticsQueryDto(ObjectMapper objectMapper, String processDefinitionId, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OrqueioQueryParam(value="canceled", converter=BooleanConverter.class)
    public void setIncludeCanceled(Boolean includeCanceled) {
        this.includeCanceled = includeCanceled;
    }

    @OrqueioQueryParam(value="finished", converter=BooleanConverter.class)
    public void setIncludeFinished(Boolean includeFinished) {
        this.includeFinished = includeFinished;
    }

    @OrqueioQueryParam(value="completeScope", converter=BooleanConverter.class)
    public void setIncludeCompleteScope(Boolean includeCompleteScope) {
        this.includeCompleteScope = includeCompleteScope;
    }

    @OrqueioQueryParam(value="incidents", converter=BooleanConverter.class)
    public void setIncludeIncidents(Boolean includeClosedIncidents) {
        this.includeIncidents = includeClosedIncidents;
    }

    @OrqueioQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @OrqueioQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @OrqueioQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @OrqueioQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @OrqueioQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return SORT_ORDER_ACTIVITY_ID.equals(value);
    }

    @Override
    protected HistoricActivityStatisticsQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricActivityStatisticsQuery(this.processDefinitionId);
    }

    @Override
    protected void applyFilters(HistoricActivityStatisticsQuery query) {
        if (this.includeCanceled != null && this.includeCanceled.booleanValue()) {
            query.includeCanceled();
        }
        if (this.includeFinished != null && this.includeFinished.booleanValue()) {
            query.includeFinished();
        }
        if (this.includeCompleteScope != null && this.includeCompleteScope.booleanValue()) {
            query.includeCompleteScope();
        }
        if (this.includeIncidents != null && this.includeIncidents.booleanValue()) {
            query.includeIncidents();
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.processInstanceIdIn != null) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
    }

    @Override
    protected void applySortBy(HistoricActivityStatisticsQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_ORDER_ACTIVITY_ID.equals(sortBy)) {
            query.orderByActivityId();
        }
    }
}

