/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import io.orqueio.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import io.orqueio.bpm.engine.history.HistoricCaseActivityStatistics;
import io.orqueio.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportDto;
import io.orqueio.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportResultDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricCaseActivityStatisticsDto;
import io.orqueio.bpm.engine.rest.history.HistoricCaseDefinitionRestService;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricCaseDefinitionRestServiceImpl
implements HistoricCaseDefinitionRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricCaseDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricCaseActivityStatisticsDto> getHistoricCaseActivityStatistics(String caseDefinitionId) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricCaseActivityStatisticsQuery historicCaseActivityStatisticsQuery = historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = historicCaseActivityStatisticsQuery.unlimitedList();
        ArrayList<HistoricCaseActivityStatisticsDto> result = new ArrayList<HistoricCaseActivityStatisticsDto>();
        for (HistoricCaseActivityStatistics currentStatistics : statistics) {
            result.add(HistoricCaseActivityStatisticsDto.fromHistoricCaseActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricCaseInstanceReportResultDto> getCleanableHistoricCaseInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricCaseInstanceReportResult> reportResult = QueryUtil.list(query, firstResult, maxResults);
        return CleanableHistoricCaseInstanceReportResultDto.convert(reportResult);
    }

    @Override
    public CountResultDto getCleanableHistoricCaseInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

