/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricDetail;
import io.orqueio.bpm.engine.history.HistoricDetailQuery;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricDetailDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricDetailQueryDto;
import io.orqueio.bpm.engine.rest.history.HistoricDetailRestService;
import io.orqueio.bpm.engine.rest.sub.history.HistoricDetailResource;
import io.orqueio.bpm.engine.rest.sub.history.impl.HistoricDetailResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricDetailRestServiceImpl
implements HistoricDetailRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricDetailRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricDetailResource historicDetail(String detailId) {
        return new HistoricDetailResourceImpl(detailId, this.processEngine);
    }

    @Override
    public List<HistoricDetailDto> getHistoricDetails(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<HistoricDetailDto> queryHistoricDetails(HistoricDetailQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        return this.executeHistoricDetailQuery(query, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public CountResultDto getHistoricDetailsCount(UriInfo uriInfo) {
        HistoricDetailQueryDto queryDto = new HistoricDetailQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricDetailQuery query = (HistoricDetailQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    private List<HistoricDetailDto> executeHistoricDetailQuery(HistoricDetailQuery query, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<HistoricDetail> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricDetailDto> result = new ArrayList<HistoricDetailDto>();
        for (HistoricDetail historicDetail : queryResult) {
            HistoricDetailDto dto = HistoricDetailDto.fromHistoricDetail(historicDetail);
            result.add(dto);
        }
        return result;
    }
}

