/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.optimize;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.history.HistoricActivityInstance;
import io.orqueio.bpm.engine.history.HistoricDecisionInstance;
import io.orqueio.bpm.engine.history.HistoricIncident;
import io.orqueio.bpm.engine.history.HistoricProcessInstance;
import io.orqueio.bpm.engine.history.HistoricTaskInstance;
import io.orqueio.bpm.engine.history.HistoricVariableUpdate;
import io.orqueio.bpm.engine.history.UserOperationLogEntry;
import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.engine.impl.persistence.entity.optimize.OptimizeHistoricIdentityLinkLogEntity;
import io.orqueio.bpm.engine.rest.dto.converter.DateConverter;
import io.orqueio.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricIncidentDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricTaskInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import io.orqueio.bpm.engine.rest.dto.history.optimize.OptimizeHistoricActivityInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.optimize.OptimizeHistoricIdentityLinkLogDto;
import io.orqueio.bpm.engine.rest.dto.history.optimize.OptimizeHistoricVariableUpdateDto;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Produces(value={"application/json"})
public class OptimizeRestService
extends AbstractRestProcessEngineAware {
    public static final String PATH = "/optimize";
    private final DateConverter dateConverter = new DateConverter();

    public OptimizeRestService(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
        this.dateConverter.setObjectMapper(objectMapper);
    }

    @GET
    @Path(value="/activity-instance/completed")
    public List<OptimizeHistoricActivityInstanceDto> getCompletedHistoricActivityInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicActivityInstances = config.getOptimizeService().getCompletedHistoricActivityInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<OptimizeHistoricActivityInstanceDto> result = new ArrayList<OptimizeHistoricActivityInstanceDto>();
        for (HistoricActivityInstance instance : historicActivityInstances) {
            OptimizeHistoricActivityInstanceDto dto = OptimizeHistoricActivityInstanceDto.fromHistoricActivityInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/activity-instance/running")
    public List<OptimizeHistoricActivityInstanceDto> getRunningHistoricActivityInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicActivityInstances = config.getOptimizeService().getRunningHistoricActivityInstances(startedAfter, startedAt, maxResults);
        ArrayList<OptimizeHistoricActivityInstanceDto> result = new ArrayList<OptimizeHistoricActivityInstanceDto>();
        for (HistoricActivityInstance instance : historicActivityInstances) {
            OptimizeHistoricActivityInstanceDto dto = OptimizeHistoricActivityInstanceDto.fromHistoricActivityInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/task-instance/completed")
    public List<HistoricTaskInstanceDto> getCompletedHistoricTaskInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicTaskInstances = config.getOptimizeService().getCompletedHistoricTaskInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance instance : historicTaskInstances) {
            HistoricTaskInstanceDto dto = HistoricTaskInstanceDto.fromHistoricTaskInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/task-instance/running")
    public List<HistoricTaskInstanceDto> getRunningHistoricTaskInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicTaskInstances = config.getOptimizeService().getRunningHistoricTaskInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance instance : historicTaskInstances) {
            HistoricTaskInstanceDto dto = HistoricTaskInstanceDto.fromHistoricTaskInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/user-operation")
    public List<UserOperationLogEntryDto> getHistoricUserOperationLogs(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List operationLogEntries = config.getOptimizeService().getHistoricUserOperationLogs(occurredAfter, occurredAt, maxResults);
        ArrayList<UserOperationLogEntryDto> result = new ArrayList<UserOperationLogEntryDto>();
        for (UserOperationLogEntry logEntry : operationLogEntries) {
            UserOperationLogEntryDto dto = UserOperationLogEntryDto.map(logEntry);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/identity-link-log")
    public List<OptimizeHistoricIdentityLinkLogDto> getHistoricIdentityLinkLogs(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List operationLogEntries = config.getOptimizeService().getHistoricIdentityLinkLogs(occurredAfter, occurredAt, maxResults);
        ArrayList<OptimizeHistoricIdentityLinkLogDto> result = new ArrayList<OptimizeHistoricIdentityLinkLogDto>();
        for (OptimizeHistoricIdentityLinkLogEntity logEntry : operationLogEntries) {
            OptimizeHistoricIdentityLinkLogDto dto = OptimizeHistoricIdentityLinkLogDto.fromHistoricIdentityLink(logEntry);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/completed")
    public List<HistoricProcessInstanceDto> getCompletedHistoricProcessInstances(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getCompletedHistoricProcessInstances(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/process-instance/running")
    public List<HistoricProcessInstanceDto> getRunningHistoricProcessInstances(@QueryParam(value="startedAfter") String startedAfterAsString, @QueryParam(value="startedAt") String startedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date startedAfter = this.dateConverter.convertQueryParameterToType(startedAfterAsString);
        Date startedAt = this.dateConverter.convertQueryParameterToType(startedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicProcessInstances = config.getOptimizeService().getRunningHistoricProcessInstances(startedAfter, startedAt, maxResults);
        ArrayList<HistoricProcessInstanceDto> result = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance instance : historicProcessInstances) {
            HistoricProcessInstanceDto dto = HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/variable-update")
    public List<OptimizeHistoricVariableUpdateDto> getHistoricVariableUpdates(@QueryParam(value="occurredAfter") String occurredAfterAsString, @QueryParam(value="occurredAt") String occurredAtAsString, @QueryParam(value="excludeObjectValues") boolean excludeObjectValues, @QueryParam(value="maxResults") int maxResults) {
        Date occurredAfter = this.dateConverter.convertQueryParameterToType(occurredAfterAsString);
        Date occurredAt = this.dateConverter.convertQueryParameterToType(occurredAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicVariableUpdates = config.getOptimizeService().getHistoricVariableUpdates(occurredAfter, occurredAt, excludeObjectValues, maxResults);
        ArrayList<OptimizeHistoricVariableUpdateDto> result = new ArrayList<OptimizeHistoricVariableUpdateDto>();
        for (HistoricVariableUpdate instance : historicVariableUpdates) {
            OptimizeHistoricVariableUpdateDto dto = OptimizeHistoricVariableUpdateDto.fromHistoricVariableUpdate(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/incident/completed")
    public List<HistoricIncidentDto> getCompletedHistoricIncidents(@QueryParam(value="finishedAfter") String finishedAfterAsString, @QueryParam(value="finishedAt") String finishedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date finishedAfter = this.dateConverter.convertQueryParameterToType(finishedAfterAsString);
        Date finishedAt = this.dateConverter.convertQueryParameterToType(finishedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicIncidents = config.getOptimizeService().getCompletedHistoricIncidents(finishedAfter, finishedAt, maxResults);
        ArrayList<HistoricIncidentDto> result = new ArrayList<HistoricIncidentDto>();
        for (HistoricIncident instance : historicIncidents) {
            HistoricIncidentDto dto = HistoricIncidentDto.fromHistoricIncident(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/incident/open")
    public List<HistoricIncidentDto> getOpenHistoricIncidents(@QueryParam(value="createdAfter") String createdAfterAsString, @QueryParam(value="createdAt") String createdAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date createdAfter = this.dateConverter.convertQueryParameterToType(createdAfterAsString);
        Date createdAt = this.dateConverter.convertQueryParameterToType(createdAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicIncidents = config.getOptimizeService().getOpenHistoricIncidents(createdAfter, createdAt, maxResults);
        ArrayList<HistoricIncidentDto> result = new ArrayList<HistoricIncidentDto>();
        for (HistoricIncident instance : historicIncidents) {
            HistoricIncidentDto dto = HistoricIncidentDto.fromHistoricIncident(instance);
            result.add(dto);
        }
        return result;
    }

    @GET
    @Path(value="/decision-instance")
    public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(@QueryParam(value="evaluatedAfter") String evaluatedAfterAsString, @QueryParam(value="evaluatedAt") String evaluatedAtAsString, @QueryParam(value="maxResults") int maxResults) {
        Date evaluatedAfter = this.dateConverter.convertQueryParameterToType(evaluatedAfterAsString);
        Date evaluatedAt = this.dateConverter.convertQueryParameterToType(evaluatedAtAsString);
        maxResults = this.ensureValidMaxResults(maxResults);
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List historicDecisionInstances = config.getOptimizeService().getHistoricDecisionInstances(evaluatedAfter, evaluatedAt, maxResults);
        ArrayList<HistoricDecisionInstanceDto> resultList = new ArrayList<HistoricDecisionInstanceDto>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            HistoricDecisionInstanceDto dto = HistoricDecisionInstanceDto.fromHistoricDecisionInstance(historicDecisionInstance);
            resultList.add(dto);
        }
        return resultList;
    }

    protected int ensureValidMaxResults(int givenMaxResults) {
        return givenMaxResults > 0 ? givenMaxResults : Integer.MAX_VALUE;
    }
}

