/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.history.impl;

import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricActivityInstance;
import io.orqueio.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricActivityInstanceResourceImpl
implements HistoricActivityInstanceResource {
    private ProcessEngine engine;
    private String activityInstanceId;

    public HistoricActivityInstanceResourceImpl(ProcessEngine engine, String activityInstanceId) {
        this.engine = engine;
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public HistoricActivityInstanceDto getHistoricActivityInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricActivityInstance instance = (HistoricActivityInstance)historyService.createHistoricActivityInstanceQuery().activityInstanceId(this.activityInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic activity instance with id '" + this.activityInstanceId + "' does not exist");
        }
        HistoricActivityInstanceDto historicActivityInstanceDto = new HistoricActivityInstanceDto();
        HistoricActivityInstanceDto.fromHistoricActivityInstance(historicActivityInstanceDto, instance);
        return historicActivityInstanceDto;
    }
}

