/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.history.impl;

import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricCaseActivityInstance;
import io.orqueio.bpm.engine.rest.dto.history.HistoricCaseActivityInstanceDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.history.HistoricCaseActivityInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricCaseActivityInstanceResourceImpl
implements HistoricCaseActivityInstanceResource {
    private ProcessEngine engine;
    private String caseActivityInstanceId;

    public HistoricCaseActivityInstanceResourceImpl(ProcessEngine engine, String caseActivityInstanceId) {
        this.engine = engine;
        this.caseActivityInstanceId = caseActivityInstanceId;
    }

    @Override
    public HistoricCaseActivityInstanceDto getHistoricCaseActivityInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricCaseActivityInstance instance = (HistoricCaseActivityInstance)historyService.createHistoricCaseActivityInstanceQuery().caseActivityInstanceId(this.caseActivityInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic case activity instance with id '" + this.caseActivityInstanceId + "' does not exist");
        }
        return HistoricCaseActivityInstanceDto.fromHistoricCaseActivityInstance(instance);
    }
}

