/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.history.impl;

import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.history.HistoricJobLog;
import io.orqueio.bpm.engine.rest.dto.history.HistoricJobLogDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.history.HistoricJobLogResource;
import jakarta.ws.rs.core.Response;

public class HistoricJobLogResourceImpl
implements HistoricJobLogResource {
    protected String id;
    protected ProcessEngine engine;

    public HistoricJobLogResourceImpl(String id, ProcessEngine engine) {
        this.id = id;
        this.engine = engine;
    }

    @Override
    public HistoricJobLogDto getHistoricJobLog() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricJobLog historicJobLog = (HistoricJobLog)historyService.createHistoricJobLogQuery().logId(this.id).singleResult();
        if (historicJobLog == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic job log with id " + this.id + " does not exist");
        }
        return HistoricJobLogDto.fromHistoricJobLog(historicJobLog);
    }

    @Override
    public String getStacktrace() {
        try {
            HistoryService historyService = this.engine.getHistoryService();
            String stacktrace = historyService.getHistoricJobLogExceptionStacktrace(this.id);
            return stacktrace;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

