/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.identity.Group;
import io.orqueio.bpm.engine.rest.dto.ResourceOptionsDto;
import io.orqueio.bpm.engine.rest.dto.identity.GroupDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.identity.GroupMembersResource;
import io.orqueio.bpm.engine.rest.sub.identity.GroupResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.GroupMembersResourceImpl;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class GroupResourceImpl
extends AbstractIdentityResource
implements GroupResource {
    private String rootResourcePath;

    public GroupResourceImpl(String processEngineName, String groupId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.GROUP, groupId, objectMapper);
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public GroupDto getGroup(UriInfo context) {
        Group dbGroup = this.findGroupObject();
        if (dbGroup == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Group with id " + this.resourceId + " does not exist");
        }
        GroupDto group = GroupDto.fromGroup(dbGroup);
        return group;
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/group").path(this.resourceId).build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(uri, "PUT", "update");
        }
        return dto;
    }

    @Override
    public void updateGroup(GroupDto group) {
        this.ensureNotReadOnly();
        Group dbGroup = this.findGroupObject();
        if (dbGroup == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Group with id " + this.resourceId + " does not exist");
        }
        group.update(dbGroup);
        this.identityService.saveGroup(dbGroup);
    }

    @Override
    public void deleteGroup() {
        this.ensureNotReadOnly();
        this.identityService.deleteGroup(this.resourceId);
    }

    @Override
    public GroupMembersResource getGroupMembersResource() {
        return new GroupMembersResourceImpl(this.getProcessEngine().getName(), this.resourceId, this.rootResourcePath, this.getObjectMapper());
    }

    protected Group findGroupObject() {
        try {
            return (Group)this.identityService.createGroupQuery().groupId(this.resourceId).singleResult();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Exception while performing group query: " + e.getMessage());
        }
    }
}

