/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.rest.dto.ResourceOptionsDto;
import io.orqueio.bpm.engine.rest.sub.identity.TenantGroupMembersResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import io.orqueio.bpm.engine.rest.util.PathUtil;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class TenantGroupMembersResourceImpl
extends AbstractIdentityResource
implements TenantGroupMembersResource {
    public TenantGroupMembersResourceImpl(String processEngineName, String resourceId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.TENANT_MEMBERSHIP, resourceId, objectMapper);
        this.relativeRootResourcePath = rootResourcePath;
    }

    @Override
    public void createMembership(String groupId) {
        this.ensureNotReadOnly();
        groupId = PathUtil.decodePathParam(groupId);
        this.identityService.createTenantGroupMembership(this.resourceId, groupId);
    }

    @Override
    public void deleteMembership(String groupId) {
        this.ensureNotReadOnly();
        groupId = PathUtil.decodePathParam(groupId);
        this.identityService.deleteTenantGroupMembership(this.resourceId, groupId);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/tenant").path(this.resourceId).path("/group-members").build(new Object[0]);
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            dto.addReflexiveLink(uri, "PUT", "create");
        }
        return dto;
    }
}

