/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.identity.Tenant;
import io.orqueio.bpm.engine.rest.dto.ResourceOptionsDto;
import io.orqueio.bpm.engine.rest.dto.identity.TenantDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.identity.TenantGroupMembersResource;
import io.orqueio.bpm.engine.rest.sub.identity.TenantResource;
import io.orqueio.bpm.engine.rest.sub.identity.TenantUserMembersResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.TenantGroupMembersResourceImpl;
import io.orqueio.bpm.engine.rest.sub.identity.impl.TenantUserMembersResourceImpl;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class TenantResourceImpl
extends AbstractIdentityResource
implements TenantResource {
    private String rootResourcePath;

    public TenantResourceImpl(String processEngineName, String tenantId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.TENANT, tenantId, objectMapper);
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public TenantDto getTenant(UriInfo context) {
        Tenant tenant = this.findTenantObject();
        if (tenant == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Tenant with id " + this.resourceId + " does not exist");
        }
        TenantDto dto = TenantDto.fromTenant(tenant);
        return dto;
    }

    @Override
    public void updateTenant(TenantDto tenantDto) {
        this.ensureNotReadOnly();
        Tenant tenant = this.findTenantObject();
        if (tenant == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Tenant with id " + this.resourceId + " does not exist");
        }
        tenantDto.update(tenant);
        this.identityService.saveTenant(tenant);
    }

    @Override
    public void deleteTenant() {
        this.ensureNotReadOnly();
        this.identityService.deleteTenant(this.resourceId);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/tenant").path(this.resourceId).build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(uri, "PUT", "update");
        }
        return dto;
    }

    @Override
    public TenantUserMembersResource getTenantUserMembersResource() {
        return new TenantUserMembersResourceImpl(this.getProcessEngine().getName(), this.resourceId, this.rootResourcePath, this.getObjectMapper());
    }

    @Override
    public TenantGroupMembersResource getTenantGroupMembersResource() {
        return new TenantGroupMembersResourceImpl(this.getProcessEngine().getName(), this.resourceId, this.rootResourcePath, this.getObjectMapper());
    }

    protected Tenant findTenantObject() {
        try {
            return (Tenant)this.identityService.createTenantQuery().tenantId(this.resourceId).singleResult();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Exception while performing tenant query: " + e.getMessage());
        }
    }
}

