/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.repository.impl;

import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.RepositoryService;
import io.orqueio.bpm.engine.exception.NotFoundException;
import io.orqueio.bpm.engine.exception.NotValidException;
import io.orqueio.bpm.engine.impl.util.IoUtil;
import io.orqueio.bpm.engine.repository.DecisionRequirementsDefinition;
import io.orqueio.bpm.engine.rest.dto.repository.DecisionRequirementsDefinitionDto;
import io.orqueio.bpm.engine.rest.dto.repository.DecisionRequirementsDefinitionXmlDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.sub.repository.DecisionRequirementsDefinitionResource;
import io.orqueio.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import io.orqueio.bpm.engine.rest.util.URLEncodingUtil;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class DecisionRequirementsDefinitionResourceImpl
implements DecisionRequirementsDefinitionResource {
    protected ProcessEngine engine;
    protected String decisionRequirementsDefinitionId;

    public DecisionRequirementsDefinitionResourceImpl(ProcessEngine engine, String decisionDefinitionId) {
        this.engine = engine;
        this.decisionRequirementsDefinitionId = decisionDefinitionId;
    }

    @Override
    public DecisionRequirementsDefinitionDto getDecisionRequirementsDefinition() {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        DecisionRequirementsDefinition definition = null;
        try {
            definition = repositoryService.getDecisionRequirementsDefinition(this.decisionRequirementsDefinitionId);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e));
        }
        return DecisionRequirementsDefinitionDto.fromDecisionRequirementsDefinition(definition);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DecisionRequirementsDefinitionXmlDto getDecisionRequirementsDefinitionDmnXml() {
        DecisionRequirementsDefinitionXmlDto decisionRequirementsDefinitionXmlDto;
        InputStream decisionRequirementsModelInputStream = null;
        try {
            decisionRequirementsModelInputStream = this.engine.getRepositoryService().getDecisionRequirementsModel(this.decisionRequirementsDefinitionId);
            byte[] decisionRequirementsModel = IoUtil.readInputStream((InputStream)decisionRequirementsModelInputStream, (String)"decisionRequirementsModelDmnXml");
            decisionRequirementsDefinitionXmlDto = DecisionRequirementsDefinitionXmlDto.create(this.decisionRequirementsDefinitionId, new String(decisionRequirementsModel, "UTF-8"));
        }
        catch (NotFoundException e) {
            try {
                throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
                catch (NotValidException e2) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e2), e2.getMessage());
                }
                catch (ProcessEngineException e3) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e3));
                }
                catch (UnsupportedEncodingException e4) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e4);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(decisionRequirementsModelInputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)decisionRequirementsModelInputStream);
        return decisionRequirementsDefinitionXmlDto;
    }

    @Override
    public Response getDecisionRequirementsDefinitionDiagram() {
        DecisionRequirementsDefinition definition = this.engine.getRepositoryService().getDecisionRequirementsDefinition(this.decisionRequirementsDefinitionId);
        InputStream decisionRequirementsDiagram = this.engine.getRepositoryService().getDecisionRequirementsDiagram(this.decisionRequirementsDefinitionId);
        if (decisionRequirementsDiagram == null) {
            return Response.noContent().build();
        }
        String fileName = definition.getDiagramResourceName();
        return Response.ok((Object)decisionRequirementsDiagram).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(fileName)).type(ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix(fileName)).build();
    }
}

