/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.BadUserRequestException;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.exception.NotFoundException;
import io.orqueio.bpm.engine.rest.dto.AnnotationDto;
import io.orqueio.bpm.engine.rest.dto.runtime.IncidentDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.runtime.IncidentResource;
import io.orqueio.bpm.engine.runtime.Incident;
import jakarta.ws.rs.core.Response;

public class IncidentResourceImpl
implements IncidentResource {
    protected ProcessEngine engine;
    protected String incidentId;
    protected ObjectMapper objectMapper;

    public IncidentResourceImpl(ProcessEngine engine, String incidentId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.incidentId = incidentId;
        this.objectMapper = objectMapper;
    }

    @Override
    public IncidentDto getIncident() {
        Incident incident = (Incident)this.engine.getRuntimeService().createIncidentQuery().incidentId(this.incidentId).singleResult();
        if (incident == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching incident with id " + this.incidentId);
        }
        return IncidentDto.fromIncident(incident);
    }

    @Override
    public void resolveIncident() {
        try {
            this.engine.getRuntimeService().resolveIncident(this.incidentId);
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public Response setAnnotation(AnnotationDto annotationDto) {
        this.engine.getRuntimeService().setAnnotationForIncidentById(this.incidentId, annotationDto.getAnnotation());
        return Response.noContent().build();
    }

    @Override
    public Response clearAnnotation() {
        this.engine.getRuntimeService().clearAnnotationForIncidentById(this.incidentId);
        return Response.noContent().build();
    }
}

