/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.CaseService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.sub.impl.AbstractVariablesResource;
import io.orqueio.bpm.engine.variable.VariableMap;
import io.orqueio.bpm.engine.variable.value.TypedValue;
import java.util.List;
import java.util.Map;

public class CaseExecutionVariablesResource
extends AbstractVariablesResource {
    public CaseExecutionVariablesResource(ProcessEngine engine, String resourceId, ObjectMapper objectMapper) {
        super(engine, resourceId, objectMapper);
    }

    @Override
    protected VariableMap getVariableEntities(boolean deserializeValues) {
        CaseService caseService = this.engine.getCaseService();
        return caseService.getVariablesTyped(this.resourceId, deserializeValues);
    }

    @Override
    protected void updateVariableEntities(VariableMap variables, List<String> deletions) {
        CaseService caseService = this.engine.getCaseService();
        caseService.withCaseExecution(this.resourceId).setVariables((Map)variables).removeVariables(deletions).execute();
    }

    @Override
    protected void removeVariableEntity(String variableKey) {
        CaseService caseService = this.engine.getCaseService();
        caseService.withCaseExecution(this.resourceId).removeVariable(variableKey).execute();
    }

    @Override
    protected String getResourceTypeName() {
        return "case execution";
    }

    @Override
    protected TypedValue getVariableEntity(String variableKey, boolean deserializeValue) {
        CaseService caseService = this.engine.getCaseService();
        return caseService.getVariableTyped(this.resourceId, variableKey, deserializeValue);
    }

    @Override
    protected void setVariableEntity(String variableKey, TypedValue variableValue) {
        CaseService caseService = this.engine.getCaseService();
        caseService.withCaseExecution(this.resourceId).setVariable(variableKey, (Object)variableValue).execute();
    }
}

