/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.impl.RuntimeServiceImpl;
import io.orqueio.bpm.engine.rest.sub.impl.AbstractVariablesResource;
import io.orqueio.bpm.engine.variable.VariableMap;
import io.orqueio.bpm.engine.variable.value.TypedValue;
import java.util.List;
import java.util.Map;

public class ExecutionVariablesResource
extends AbstractVariablesResource {
    private String resourceTypeName;

    public ExecutionVariablesResource(ProcessEngine engine, String resourceId, boolean isProcessInstance, ObjectMapper objectMapper) {
        super(engine, resourceId, objectMapper);
        this.resourceTypeName = isProcessInstance ? "process instance" : "execution";
    }

    @Override
    protected String getResourceTypeName() {
        return this.resourceTypeName;
    }

    @Override
    protected void updateVariableEntities(VariableMap modifications, List<String> deletions) {
        RuntimeServiceImpl runtimeService = (RuntimeServiceImpl)this.engine.getRuntimeService();
        runtimeService.updateVariables(this.resourceId, (Map)modifications, deletions);
    }

    @Override
    protected void removeVariableEntity(String variableKey) {
        this.engine.getRuntimeService().removeVariable(this.resourceId, variableKey);
    }

    @Override
    protected VariableMap getVariableEntities(boolean deserializeValues) {
        return this.engine.getRuntimeService().getVariablesTyped(this.resourceId, deserializeValues);
    }

    @Override
    protected TypedValue getVariableEntity(String variableKey, boolean deserializeValue) {
        return this.engine.getRuntimeService().getVariableTyped(this.resourceId, variableKey, deserializeValue);
    }

    @Override
    protected void setVariableEntity(String variableKey, TypedValue variableValue) {
        this.engine.getRuntimeService().setVariable(this.resourceId, variableKey, (Object)variableValue);
    }
}

