/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.util;

import io.orqueio.bpm.engine.impl.ManagementServiceImpl;
import io.orqueio.bpm.engine.impl.diagnostics.PlatformDiagnosticsRegistry;
import io.orqueio.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import io.orqueio.bpm.engine.rest.spi.ProcessEngineProvider;
import io.orqueio.bpm.engine.rest.util.EngineUtil;

public class WebApplicationUtil {
    public static void setApplicationServer(String serverInfo) {
        if (serverInfo != null && !serverInfo.isEmpty() && PlatformDiagnosticsRegistry.getApplicationServer() == null) {
            PlatformDiagnosticsRegistry.setApplicationServer((String)serverInfo);
        }
    }

    public static void setLicenseKey(LicenseKeyDataImpl licenseKeyData) {
        if (licenseKeyData != null) {
            ProcessEngineProvider processEngineProvider = EngineUtil.getProcessEngineProvider();
            for (String engineName : processEngineProvider.getProcessEngineNames()) {
                if (engineName == null) continue;
                ManagementServiceImpl managementService = (ManagementServiceImpl)processEngineProvider.getProcessEngine(engineName).getManagementService();
                managementService.setLicenseKeyForDiagnostics(licenseKeyData);
            }
        }
    }

    public static boolean setWebapp(String engineName, String webapp) {
        ProcessEngineProvider processEngineProvider = EngineUtil.getProcessEngineProvider();
        ManagementServiceImpl managementService = (ManagementServiceImpl)processEngineProvider.getProcessEngine(engineName).getManagementService();
        return managementService.addWebappToTelemetry(webapp);
    }
}

